<?php
  //Wmaker API Client Kit PHP
  /**
  * @version 2.0 - 
  * 01/01/2017
  * @copyright Wmaker.net
  * @author Samir AMZANI / Sebastien PEREZ : seb2@wmaker.net
  */
  
  class WM_Api_Client
        {
        private $api_rest_url;
        private $api_upload_url;
        private $api_format;
        private $api_key;
        private $api_secret;
        private $api_sig;
        public  $debug = false;
        
        /**
        * WM_Api_Client constructor
        * 
        * @param mixed $api_rest_url (exemple : http://blog.wmaker.net/api/)
        * @param mixed $api_format (php, json or xml)
        * @param mixed $api_key 
        * @param mixed $api_secret
        * @return WM_Api_Client
        */
        public function __construct($api_rest_url, $api_format, $api_key, $api_secret)
                {
                $this->api_rest_url  = $api_rest_url;
                $this->api_key       = $api_key;
                $this->api_secret    = $api_secret;
                $this->api_format    = $api_format;                
                }
        
        /**
        * Call a Wmaker API method
        *         
        * @param mixed $method
        * @param mixed $args
        * @return mixed
        */
        public function call($method, $args=array()) 
                {
                $args['api_sig']  = $this->generateSig($method);
                $this->api_sig    = $args['api_sig'] ;
                $args['method'] = $method;
                $args['api_key'] = $this->api_key;
                $args['format']  = $this->api_format;
                if ($this->debug)
                	{
                	echo "call (args) <br>";
                	echo "<pre>";
                	print_r($args);
                	} 
                return $this->request($args);
                }
                
        /**
        * Generate the api_sig
        *         
        * @param mixed $args
        * @return string
        */
        private function generateSig($method) 
                {
                //Just method arguments here!
                return(md5($this->api_secret . $this->api_key . $method));
                }
                
        public function getApiSig()
                {
                return $this->api_sig;        
                }
        /**
        * Make a REST request (POST)
        * 
        * @param mixed $args
        * @return mixed
        */
        public function request($args) 
                {          

                // Check each post field
                foreach($args as $key => $value)
                    {
                    // Convert values for keys starting with '@' prefix
                    if(strpos($value, '@') === 0)
                        {
                        // Get the file name
                        $filename = ltrim($value, '@');
                        // Convert the value to the new class
                        $args[$key] = new CURLFile($filename);
                        }
                    }

                //Other arguments
                $ch = curl_init($this->api_rest_url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $args);


                $data = curl_exec($ch);
                if(curl_errno($ch))
                        {
                        return false;
                        }
                else 
                        {
                        curl_close($ch);
                        }
                if ($this->api_format == "php")
                        {
                        $data =  unserialize($data);
                        }
                
                return $data;
                }
                

                
        }
  

?>
